Ext.data.JsonP.sol_common_Roles({"tagname":"class","name":"sol.common.Roles","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.Roles.js","href":"lib_sol.common.Roles.html#sol-common-Roles"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloall":true,"requires":["handlebars","sol.common.SordUtils","sol.common.Template"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"fct","tagname":"property","owner":"sol.common.Roles","id":"property-fct","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getSupervisor","tagname":"method","owner":"sol.common.Roles","id":"method-getSupervisor","meta":{}},{"name":"getUserName","tagname":"method","owner":"sol.common.Roles","id":"method-getUserName","meta":{"private":true}},{"name":"getUsers","tagname":"method","owner":"sol.common.Roles","id":"method-getUsers","meta":{}},{"name":"getUsers2","tagname":"method","owner":"sol.common.Roles","id":"method-getUsers2","meta":{}},{"name":"getUsersByRole","tagname":"method","owner":"sol.common.Roles","id":"method-getUsersByRole","meta":{"private":true}},{"name":"getValue","tagname":"method","owner":"sol.common.Roles","id":"method-getValue","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"retrieveRole","tagname":"method","owner":"sol.common.Roles","id":"method-retrieveRole","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.Roles","short_doc":"Roles can be used in order to identify a proper user e.g. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.Roles</strong></div></div><h4>Requires</h4><div class='dependency'>handlebars</div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.Roles.html#sol-common-Roles' target='_blank'>lib_sol.common.Roles.js</a></div></pre><div class='doc-contents'><p>Roles can be used in order to identify a proper user e.g. in a workflow.</p>\n\n<p>E.g. in an invoice approval process a user should be added to the approval process if the invoice amount exceeds a\ndefined value. In this scenario, the management group should approve invoices that are more expansive than 100000€.</p>\n\n<p>Contains the functions used to determine the correct users using a configuration object. If more then one user will be suitable, the configuration order will be maintained.</p>\n\n<h1>Configuration</h1>\n\n<h2>Example</h2>\n\n<p>The configuration is an Array which contains Objects containing the rolenames as <code>name</code> property and an <code>users</code> property which is an Array of user configurations.\nThis user configuration objects have at least a <code>user</code> property, which is the ELO username. Additionally each object can contain several conditions, which are defined thanks to an Array.</p>\n\n<pre><code>var myRoleConfig = [\n  {\n    \"name\": \"ROLE_1\",\n    \"users\": [\n      { user : \"user1\", conditions: [ { type: \"GRP\", key: \"AMOUNT\", rel: \"GT\", val: 3000, dataType: \"number\" } ] },\n      { user : \"user2\" }\n    ]\n  },\n  {\n    name: \"ROLE_2\",\n    users: [\n      { user: \"user2\", conditions: [ { type: \"GRP\", key: \"RECIPIENT_NO\", rel: \"EQUALS\", val: \"4713\"} ] },\n      { user: \"group1\" }\n    ]\n  },\n  {\n    name: \"ROLE_3\",\n    users: [\n      { user: { type: \"GRP\", key: \"PO_PURCHASE_USER\", mode: \"SUPERVISOR\", supervisorLevel: 2 }, conditions: [ { type: \"GRP\", key: \"AMOUNT\", rel: \"GE\", val: \"4714\"} ] },\n    ]\n  }\n]\n</code></pre>\n\n<h2>Conditions</h2>\n\n<p>Conditions are optional and are used to limit the users depending on the values in an Sord object. Conditions are an Array of Objects.</p>\n\n<pre><code>{\n  // type of field (GRP|SORD)\n  type: \"GRP\",\n  // name of the index group, or sord property\n  key : \"{ELO OBJEKY GROUPNAME}\",\n  // relation for the check\n  rel : \"{RELATION}\",\n  // value to check for\n  val : \"{VALUE}\"\n}\n</code></pre>\n\n<p>If conditions are configured, all of them must meet the requirements.</p>\n\n<p>Supported relations are:</p>\n\n<ul>\n<li><code>GT</code>: value is greater than <code>x</code></li>\n<li><code>GE</code>: value is greater or equal than <code>x</code></li>\n<li><code>LT</code>: value is lower than <code>x</code></li>\n<li><code>LE</code>: value is lower or equal than <code>x</code></li>\n<li><code>EQUALS</code>: value is equal to <code>x</code></li>\n</ul>\n\n\n<h1>Retrieving a user list</h1>\n\n<pre><code>var sord = ixConnect.ix().checkoutSord(...);\nvar users = <a href=\"#!/api/sol.common.Roles-method-getUsers\" rel=\"sol.common.Roles-method-getUsers\" class=\"docClass\">sol.common.Roles.getUsers</a>('MYROLE', sord, myRoleConfig);\n</code></pre>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-fct' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-property-fct' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-property-fct' class='name expandable'>fct</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>Contains the calculation rules.</p>\n</div><div class='long'><p>Contains the calculation rules.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getSupervisor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-method-getSupervisor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-method-getSupervisor' class='name expandable'>getSupervisor</a>( <span class='pre'>userDef, userName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the supervisor of the specified level ...</div><div class='long'><p>Returns the supervisor of the specified level</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userDef</span> : Object<div class='sub-desc'><p>User definition</p>\n</div></li><li><span class='pre'>userName</span> : String<div class='sub-desc'><p>User name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Supervisor</p>\n</div></li></ul></div></div></div><div id='method-getUserName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-method-getUserName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-method-getUserName' class='name expandable'>getUserName</a>( <span class='pre'>sord, rule</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns the username ...</div><div class='long'><p>Returns the username</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li><li><span class='pre'>rule</span> : Object<div class='sub-desc'><p>Rule</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-method-getUsers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-method-getUsers' class='name expandable'>getUsers</a>( <span class='pre'>role, sord, config</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>This function evaluates a configuration to find all suitable users for a role. ...</div><div class='long'><p>This function evaluates a configuration to find all suitable users for a role.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>role</span> : String|Object<div class='sub-desc'><p>Role name. If this is defined as an object, a <code>type</code> and a <code>key</code> has to be defined to load the role from the sords metadata (see <a href=\"#!/api/sol.common.SordUtils-method-getValue\" rel=\"sol.common.SordUtils-method-getValue\" class=\"docClass\">sol.common.SordUtils.getValue</a>).</p>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord to check conditions from config</p>\n</div></li><li><span class='pre'>config</span> : Object[]<div class='sub-desc'><p>Configuration object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Array of usernames (or an empty Array)</p>\n</div></li></ul></div></div></div><div id='method-getUsers2' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-method-getUsers2' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-method-getUsers2' class='name expandable'>getUsers2</a>( <span class='pre'>role, sord, originalConfig</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>This function evaluates a configuration to find all suitable users for a role. ...</div><div class='long'><p>This function evaluates a configuration to find all suitable users for a role.\ngetUser2() considers the property 'mandatory'</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>role</span> : String|Object<div class='sub-desc'><p>Role name. If this is defined as an object, a <code>type</code> and a <code>key</code> has to be defined to load the role from the sords metadata (see <a href=\"#!/api/sol.common.SordUtils-method-getValue\" rel=\"sol.common.SordUtils-method-getValue\" class=\"docClass\">sol.common.SordUtils.getValue</a>).</p>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord to check conditions from config</p>\n</div></li><li><span class='pre'>originalConfig</span> : Object[]<div class='sub-desc'><p>Configuration object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>Array of user entries</p>\n</div></li></ul></div></div></div><div id='method-getUsersByRole' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-method-getUsersByRole' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-method-getUsersByRole' class='name expandable'>getUsersByRole</a>( <span class='pre'>role, config</span> ) : Object[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the users for a role from the configuration array. ...</div><div class='long'><p>Retrieves the users for a role from the configuration array.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>role</span> : String<div class='sub-desc'><p>Lookup string in config object</p>\n</div></li><li><span class='pre'>config</span> : Object[]<div class='sub-desc'><p>Configuration object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'><p>Array of user configurations</p>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>sord, sordMap, condition</span> ) : String|Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Gets a value from the Sord object. ...</div><div class='long'><p>Gets a value from the Sord object.</p>\n\n<p>If the condition.val is a number this function tries to retrieve the value as a number.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li><li><span class='pre'>sordMap</span> : <a href=\"#!/api/sol.common.SordMap\" rel=\"sol.common.SordMap\" class=\"docClass\">sol.common.SordMap</a><div class='sub-desc'><p>Sord map</p>\n</div></li><li><span class='pre'>condition</span> : Object<div class='sub-desc'><p>Condition</p>\n<ul><li><span class='pre'>type</span> : String<div class='sub-desc'><p>The type were the value should be looked up (\"SORD\"|\"GRP\")</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>The lookup key (either an index field name or a sord property)</p>\n</div></li><li><span class='pre'>val</span> : String|Number<div class='sub-desc'><p>The value to which will be compared, here only used to determine the type (string or number)</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String|Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-retrieveRole' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Roles'>sol.common.Roles</span><br/><a href='source/lib_sol.common.Roles.html#sol-common-Roles-method-retrieveRole' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Roles-method-retrieveRole' class='name expandable'>retrieveRole</a>( <span class='pre'>role, rolesConfig, [sord]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Determine if a configuration has a role configured. ...</div><div class='long'><p>Determine if a configuration has a role configured.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>role</span> : String|Object<div class='sub-desc'><p>Role name. If this is defined as an object, a <code>type</code> and a <code>key</code> has to be defined to load the role from the sords metadata (see <a href=\"#!/api/sol.common.SordUtils-method-getValue\" rel=\"sol.common.SordUtils-method-getValue\" class=\"docClass\">sol.common.SordUtils.getValue</a>). It's also possible to define an object with a <code>template</code> property which contains a Handlebars template string.</p>\n</div></li><li><span class='pre'>rolesConfig</span> : Object[]<div class='sub-desc'><p>Configuration object</p>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord (optional)<div class='sub-desc'><p>Sord to check conditions from config. If <code>role</code> is an object, this has to be defined.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name of the role</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"singleton":true}});